<?php
function convert_esxi_vmpath_from_vsphere_to_vix( $argv ) {

    try {
    
        // check number of arguments
        if( count( $argv ) != 4 ) {
            throw new Exception( "Usage: " . basename( __FILE__, ".inc" ) . " <EsxiHost> <EsxiUsername> <EsxiPassword> <vSphereVmxFilePath>" ) ;
        }
        
        // fetch arguments
        $esxi_host      = $argv[ 0 ] ;
        $esxi_username  = $argv[ 1 ] ;
        $esxi_password  = $argv[ 2 ] ;
        $vmpath_vsphere = $argv[ 3 ] ;
        
        // check vsphere vmpath format: /vmfs/volumes/<DsUid>/yyyyy/yyyyy.vmx
        if( count( explode( "/", $vmpath_vsphere ) ) != 6 ) {
            throw new Exception( "InvalidVsphereVmxFilePathFormat: path='$vmpath_vsphere'" ) ;
        }
        
        // extract given DsUid
        $dsUidGiven = dirname( dirname( $vmpath_vsphere ) ) ;
        
        // get all datastorename
        debug_print( "QueryAllEsxiDatastoreName" ) ;
        $ret_array = run_program_at_esxi_by_ssh( array(
            'esxi_ip'       => $esxi_host,
            'esxi_username' => $esxi_username,
            'esxi_password' => $esxi_password,
            
            'program'   => '/bin/find',
            'arguments' => array(
                "/vmfs/volumes/",
                "-maxdepth", "1",
                "-type", "l"
        ) ) ) ;
        $retCode      = $ret_array[ 0 ] ;
        $stdoutMsgAry = $ret_array[ 1 ] ;
        $stdoutMsg    = join( ",", $stdoutMsgAry ) ;
        if( $retCode != 0 ) {
            $stderrMsgAry = $ret_array[ 2 ] ;
            $stderrMsg    = join( "\n", $stderrMsgAry ) ;
            throw new Exception( "QueryAllEsxiDatastoreNameFail: ret='$retCode', stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
        }
        $dsNameArray = $stdoutMsgAry ;
        debug_print( "QueryAllEsxiDatastoreNameSuccess: msg='$stdoutMsg'" ) ;
        # var_dump( $dsNameArray ) ;        
        
        
        // query corresponding DsName by DsUidGiven
        foreach( $dsNameArray as $dsPathCandidate ) {
            
            debug_print( "QueryEsxiDsName: dsPathCandidate='$dsPathCandidate'" ) ;
            $ret_array = run_program_at_esxi_by_ssh( array(
                'esxi_ip'       => $esxi_host,
                'esxi_username' => $esxi_username,
                'esxi_password' => $esxi_password,
                'program'       => "cd '$dsPathCandidate'; pwd -P"
            ) ) ;
            $retCode      = $ret_array[ 0 ] ;
            $stdoutMsgAry = $ret_array[ 1 ] ;
            $stdoutMsg    = join( "\n", $stdoutMsgAry ) ;
            if( $retCode != 0 ) {
                $stderrMsgAry = $ret_array[ 2 ] ;
                $stderrMsg    = join( "\n", $stderrMsgAry ) ;
                throw new Exception( "QueryEsxiDsNameFail: ret='$retCode', stdoutMsg='$stdoutMsg', stderrMsg='$stderrMsg'" ) ;
            }
            $dsUidCandidate = $stdoutMsg ;
            debug_print( "QueryEsxiDsName: dsPathCandidate='$dsPathCandidate', dsUidCandidate='$dsUidCandidate'" ) ;
            
            if( strcasecmp( $dsUidCandidate, $dsUidGiven ) == 0 ) {
                debug_print( "QueryEsxiDsNameSuccess: dsPath='$dsPathCandidate', dsUid='$dsUidCandidate', dsUidGiven='$dsUidGiven'" ) ;
                debug_print( "ConverVmpath: dsPathVsphere='$vmpath_vsphere'" ) ;

                $dsPathVix = join( "/", array( "[ha-datacenter/"  . basename( $dsPathCandidate ) . "] " . basename( dirname( $vmpath_vsphere ) ),
                                               basename( $vmpath_vsphere ) ) ) ;                
                
                debug_print( "ConverVmpathSuccess: dsPathVix='$dsPathVix'" ) ;
                echo $dsPathVix . "\n" ;
                exit( 0 ) ;
            }
        }
        
        $tmp = basename( $dsUidGiven ) ;
        throw new Exception( "DsUidNotExist: dsUid='$tmp'" ) ;
	}
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        
        debug_print( "Exception caught: $msg" ) ;
        echo $msg . "\n" ;
        
        exit( 1 ) ;
    }
}

